/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nullable;
import net.creeperhost.chickens.handler.ItemHolder;
import net.minecraft.world.item.ItemStack;

public class JsonConfig {
    boolean hasChanged = false;
    private File configFile;
    private JsonObject json;
    private Gson gson;

    public JsonConfig(File file) {
        this.configFile = file;
        this.gson = new Gson();
        this.json = new JsonObject();
    }

    public void Save() {
        this.WriteFile();
        this.hasChanged = false;
    }

    public void Load() {
        try {
            this.SetupFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.json = this.ReadFile();
    }

    public JsonObject getFullJson() {
        return this.json;
    }

    public JsonObject getCategory(String categoryProperty) {
        JsonObject object = new JsonObject();
        if (this.json.has(categoryProperty)) {
            object = this.json.getAsJsonObject(categoryProperty);
        } else {
            this.json.add(categoryProperty, (JsonElement)object);
            this.setHasChanged(true);
        }
        return object;
    }

    public boolean getBoolean(String categoryProperty, String property, boolean value) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            value = object.get(property).getAsBoolean();
        } else {
            object.addProperty(property, Boolean.valueOf(value));
            this.setHasChanged(true);
        }
        return value;
    }

    public String getString(String categoryProperty, String property, String value) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            value = object.get(property).getAsString();
        } else {
            object.addProperty(property, value);
            this.setHasChanged(true);
        }
        return value;
    }

    public float getFloat(String categoryProperty, String property, float value, float min, float max) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            value = object.get(property).getAsFloat();
        } else {
            object.addProperty(property, (Number)Float.valueOf(value));
            this.setHasChanged(true);
        }
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    @Nullable
    public ItemHolder getItemHolder(String categoryProperty, String property, ItemHolder defaultItemHolder) {
        JsonObject object = this.getCategory(categoryProperty);
        ItemHolder holder = defaultItemHolder;
        boolean useDefault = true;
        if (object.has(property)) {
            if (object.get(property).isJsonObject()) {
                holder.readJsonObject(object.get(property).getAsJsonObject());
                useDefault = false;
            } else {
                ItemStack oldItemStack = this.getItemStack(categoryProperty, property, defaultItemHolder.getStack());
                if (oldItemStack != null) {
                    object.add(property, (JsonElement)holder.writeJsonObject(new JsonObject()));
                    useDefault = false;
                    this.setHasChanged(true);
                }
            }
        }
        if (useDefault) {
            object.add(property, (JsonElement)holder.writeJsonObject(new JsonObject()));
            this.setHasChanged(true);
        }
        return holder;
    }

    @Nullable
    @Deprecated
    public ItemStack getItemStack(String categoryProperty, String property, ItemStack stack) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            stack = JsonConfig.getItemStackFromID(object.get(property).getAsString());
        } else {
            object.addProperty(property, JsonConfig.getIDfromItemStack(stack));
            this.setHasChanged(true);
        }
        return stack;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    protected void setHasChanged(boolean val) {
        this.hasChanged = val;
    }

    private void SetupFile() throws IOException {
        if (!this.configFile.exists()) {
            this.hasChanged = true;
            this.configFile.getParentFile().mkdirs();
            this.configFile.createNewFile();
        }
    }

    protected JsonObject ReadFile() {
        JsonObject obj = new JsonObject();
        try {
            FileReader fr = new FileReader(this.configFile);
            JsonObject jsonobject = (JsonObject)this.gson.fromJson((Reader)fr, JsonObject.class);
            fr.close();
            return jsonobject != null ? jsonobject : obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Error " + e.getCause() + " loading file: " + this.configFile.getPath());
        }
    }

    protected void WriteFile() {
        try {
            FileWriter fw = new FileWriter(this.configFile);
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.json, (Appendable)fw);
            fw.flush();
            fw.close();
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    protected static String getIDfromItemStack(ItemStack stack) {
        return stack.m_41720_().getRegistryName() + (String)(stack.m_41773_() != 0 || stack.m_41613_() > 1 ? ":" + stack.m_41773_() + (String)(stack.m_41613_() > 1 ? ":" + stack.m_41613_() : "") : "");
    }

    @Nullable
    protected static ItemStack getItemStackFromID(String itemID) {
        return ItemStack.f_41583_;
    }
}

